// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
			_centroid in highp vec2 uv0;
			_centroid in highp vec2 uv1;
		#else
			_centroid in vec2 uv0;
			_centroid in vec2 uv1;
		#endif
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		in vec2 uv0;
		in vec2 uv1;
	#endif
#endif

#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "util.h"
#include "lib/Hash.h"

varying highp vec3 cpos;
varying highp vec3 wpos;

varying vec4 color;

varying float farrender;
varying float farchunk;

#ifdef UNDERWATER
varying float fogr;
#endif

/////////////////////////////////////////////////////////////////
///////////////////////// STOP! /////////////////////////////////
/////////////////////////////////////////////////////////////////
// Made by @Bicubicpack.
// successfully changed (modified and optimalized) on 7 oct 2020.
// all of these assets are under MIT license.
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

#define rain (1.-pow(FOG_CONTROL.y,10.))*uv1.y

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;
LAYOUT_BINDING(2) uniform sampler2D TEXTURE_2;

vec3 calclight(vec3 c,float strength){
	vec3 lcolor = mix(vec3(dot(vec3(7.,4.,0)*strength,vec3(1.))),vec3(7.,4.,0)*strength,1.2);
	c += lcolor*pow(1.1*uv1.x,5.5);
return c;
}

//https://knarkowicz.wordpress.com/2016/01/06/aces-filmic-tone-mapping-curve/
vec3 acesFilmic(vec3 x){
    const float a = 2.51;
    const float b = 0.035;
    const float c = 2.43;
    const float d = 0.59;
    const float e = 0.15;
return clamp((x * (a * x + b)) / (x * (c * x + d) + e), 0.0, 1.0);
}

highp float calcWave(highp vec2 pos){
	highp vec2 htime = vec2(0.,TIME);
		pos *= 40.;
	highp vec2 wp = pos * mat2(vec2(sin(1.),cos(1.8)),vec2(sin(1.),cos(1.)))+(htime * 70.) * 4.0; wp.y *= 2.0;
	highp vec2 wp1 = pos * mat2(vec2(sin(1.2),cos(0.5)),vec2(sin(.5),cos(0.5)))+(htime * 70.) * 1.5; wp1.y *= 1.0;

	highp float wave = -noise(wp * 0.005) * 10.0;
		wave += noise(wp1 * 0.01) * 10.0; wave *= 0.2;
return wave;
}
highp float drawcloud(highp vec2 pos,float value){
	float tot = 0.,s= 1.;
	highp vec2 ptime = TIME*vec2(-2.,1.3);
		pos += ptime*0.008;

	for(int i = 0; i < 3; i++){
		tot += noise(pos)*1.*value/s; s *= 2.2;
		pos *= 2.5;
		pos += ptime*0.01;
	}
return 1.-pow(.1,max(1.-tot,0.));
}

vec4 calcWater(vec4 btex,vec3 N,highp vec2 ttime,highp vec2 ftime){
	float look = smoothstep(0., 1., abs(1. - dot(N, normalize(-wpos))))*uv1.y, waterw = calcWave(cpos.xz*5.);
	vec3 nw = normalize(vec3(waterw*.5,-waterw*.5,1.));
	vec4 wcolor = mix(vec4(0.,.08,0.2,0.2),vec4(FOG_COLOR.rgb,look),rain);

	highp float dvalue = mix(.03,mix(.12,.05,
uv1.y*(1.-ttime.x)),smoothstep(.87, .84, uv1.y)*(1.-ttime.x)*(1.-rain));

	highp vec3 spos = wpos;
	if(spos.x > 0.){
		spos -= spos.x*.45;
	} else { spos += spos.x*.45; }
        spos = normalize(spos * vec3(1,1,6));
	float sm = (1.-rain)*smoothstep(1.,0.,length(spos.zy))*20.,slook = (1.-FOG_COLOR.b)*clamp((FOG_COLOR.r-.15)*1.25,0.,1.);

	wcolor.rgb = mix(wcolor.rgb,mix(calclight(wcolor.rgb,0.12), calclight(wcolor.rgb, dvalue),1.-ttime.x),uv1.x+waterw*2.);

	highp float hmap = pow(dot(nw,vec3(.8,1.,.8)),5.), cmap = drawcloud(.1*wpos.xz+nw.xy*.3, 1.5);

		wcolor =  mix(wcolor+hmap*.3,FOG_COLOR+min(1.2*slook*ftime.y*4.,1.)*(sm*(hmap*.3))*smoothstep(0.,.8,uv1.y),pow(look,5.)*btex.r);
		wcolor = mix(wcolor,FOG_COLOR,cmap*.3);
		wcolor.a += pow(farchunk,5.);
return wcolor;
}

vec3 calcFog(vec3 c,highp vec2 ftime,highp vec2 ttime){
	highp vec3 spos = wpos;
	if(spos.x > 0.){
		spos -= spos.x*.45;
	} else { spos += spos.x*.45; }
		spos = normalize(spos);

	float sunamount = smoothstep(1.,0.,length(spos.zy)), sunlook = (1.-FOG_COLOR.b)*clamp((FOG_COLOR.r-.15)*1.25,0.,1.);

	vec3 fogamount = mix(vec3(0.6,0.8,1.)*FOG_COLOR.rgb,FOG_COLOR.rgb+vec3(FOG_COLOR.r,FOG_COLOR.g,FOG_COLOR.b*2.),sunamount*min(1.2*sunlook*ftime.y*3.5,1.));

return mix(c,fogamount,farrender*mix(0.7,1.3,ttime.y));
}

void main()
{
#ifdef BYPASS_PIXEL_SHADER
	gl_FragColor = vec4(0, 0, 0, 0);
	return;
#else
	highp float wf = 0.;
#if USE_TEXEL_AA
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv0);
	vec4 lc = texture2D_AA(TEXTURE_1, vec2(0,1));
#else
	vec4 diffuse = texture2D(TEXTURE_0, uv0);
	vec4 lc = texture2D(TEXTURE_1, vec2(0,1));
#endif

	highp vec2 ttime = vec2(max(1.-min(pow(lc.r*1.8,5.),1.),.0),pow(clamp((1.-pow(lc.r,5.))*1.3,.0,1.),8.))*uv1.y;

	vec2 ftime = vec2(pow(max(min(1.0-FOG_COLOR.r*1.5,1.),.0),1.2),pow(max(min(1.0-FOG_COLOR.r*1.2,1.),.0),.5));

#ifdef SEASONS_FAR
	diffuse.a = 1.0;
#endif

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
	#define ALPHA_THRESHOLD 0.05
	#else
	#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif

	vec4 inColor = color;

#if defined(BLEND)
	diffuse.a *= inColor.a;
#endif

	vec4 btex = texture2D(TEXTURE_1,vec2(pow(uv1.x,2.), uv1.y));
#if !defined(ALWAYS_LIT)
	diffuse *= btex;
#endif


#ifndef SEASONS
	#if !USE_ALPHA_TEST && !defined(BLEND)
		diffuse.a = inColor.a;
	#endif


//reduce default ambient occlusion
if(color.g * 2.0 > color.b + color.r && color.a != 0.){
	diffuse.rgb *= mix(normalize(inColor.rgb),inColor.rgb,0.5);
}else{
	diffuse.rgb *= color.a ==0.?inColor.rgb: sqrt(inColor.rgb);
}

#else
	vec2 uv = inColor.xy;
	diffuse.rgb *= mix(vec3(1.0,1.0,1.0), texture2D( TEXTURE_2, uv).rgb*2.0, inColor.b);
	diffuse.rgb *= inColor.aaa;
	diffuse.a = 1.0;
#endif

//shadowmapping detection and calculation
#ifdef FANCY
	vec3 N = normalize(cross(dFdx(cpos.xyz), dFdy(cpos.xyz)));
#endif
    highp float smap = 0.;
if(color.a == 0.){
	smap = mix(smap, 1., clamp(abs(-N.x), 0., 1.)); smap = mix(smap, 1., clamp((-N.z + N.y), 0., 1.) * ttime.y*(1.-ttime.x));
} else {
   #if !USE_ALPHA_TEST
       smap = mix(smap, 1., clamp(abs(-N.x), 0., 1.)); smap = mix(smap, 1., clamp((-N.z + N.y), 0., 1.) * ttime.y*(1.- ttime.x));
   #endif
}
    highp float ub = smoothstep(.87, .84, uv1.y);
    smap = mix(smap, 1., ub);

//color
	diffuse.rgb *= pow(diffuse.rgb, (color.a==0.)?vec3(.6,.6,.6):vec3(.7,.7,.7));
	vec3 exposureBias = mix(mix(mix(vec3(2.,2.,2.),vec3(2.5,2.2,1.),ttime.y),vec3(2.,2.2,2.4),ttime.x),vec3(1),rain);
	vec3 curr = acesFilmic(exposureBias*diffuse.rgb);
	diffuse.rgb = curr;

//shadow
	diffuse.rgb *= mix(1.+.3*(N.z)*ttime.y*(1.-ttime.x),.4,smap*(1.-max(0.,2.*uv1.x-0.8))*(1.-rain));

//light source color
	highp float dvalue= mix(.0,mix(.1,.05,uv1.y*(1.-ttime.x)),smap*(1.-ttime.x));
	diffuse.rgb = mix(diffuse.rgb,mix(calclight(diffuse.rgb,0.1),calclight(diffuse.rgb, dvalue),1.-ttime.x),uv1.x);

#if !defined(SEASONS) && !defined(ALPHA_TEST)
if(color.g < color.b && color.g > color.r){
	diffuse = calcWater(btex,N,ttime, ftime)*mix(1.,.8,smap*(1.-max(0.,2.*uv1.x-0.8))*(1.-rain)); wf =1.;
}
#endif

#ifdef UNDERWATER
if(wf != 1.){
	diffuse = vec4(vec3(.3,.7,1.),.0)*diffuse + max(0.,calcWave(cpos.xz*5.5))*uv1.y*diffuse;
}
	diffuse.rgb += (1.-uv1.y)*pow(uv1.x*1., 4.)*vec3(1,1,1);
//primary fog (only underwater)
	diffuse.rgb = mix(diffuse.rgb,FOG_COLOR.rgb,pow(fogr,7.));
#endif

//secondary fog
	diffuse.rgb = calcFog(diffuse.rgb, ftime, ttime);


//out
	gl_FragColor = diffuse;
#endif // BYPASS_PIXEL_SHADER
}
